#ifndef MAIN_H
#define MAIN_H

// <<< Use Configuration Wizard in Context Menu >>>
// <o> Group0 - LVDIF IE0
// <0x00=> Level_0 <0x01=> Level_1 <0x02=> Level_2 <0x03=> Level_3
#define Group0 0x00

// <o> Group1 - WDTIF TF0
// <0x00=> Level_0 <0x01=> Level_1 <0x02=> Level_2 <0x03=> Level_3
#define Group1 0x00

// <o> Group2 - OCPSIF ADCIF IE1
// <0x00=> Level_0 <0x01=> Level_1 <0x02=> Level_2 <0x03=> Level_3
#define Group2 0x03

// <o> Group3 - MPWMMINIF MPWMMAXIF TF1
// <0x00=> Level_0 <0x01=> Level_1 <0x02=> Level_2 <0x03=> Level_3
#define Group3 0x00

// <o> Group4 - SPIF(TI, RI)
// <0x00=> Level_0 <0x01=> Level_1 <0x02=> Level_2 <0x03=> Level_3
#define Group4 0x00

// <o> Group5 - CAPIF TF2
// <0x00=> Level_0 <0x01=> Level_1 <0x02=> Level_2 <0x03=> Level_3
#define Group5 0x00

#define IP0_REGS (Group5&0x01)<<5 |(Group4&0x01)<<4 |(Group3&0x01)<<3 |(Group2&0x01)<<2 |(Group1&0x01)<<1 |(Group0&0x01)
#define IP1_REGS (Group5&0x02)<<4 |(Group4&0x02)<<3 |(Group3&0x02)<<2 |(Group2&0x02)<<1 |(Group1&0x02)>>0 |(Group0&0x02)>>1

// <<< end of configuration section >>>

#define Timer1ms 1
#define Timer5ms 5
#define Timer10ms 10

#define PeriodTime10ms 10
#define PeriodTime20ms 20
#define PeriodTime30ms 30
#define PeriodTime40ms 40
#define PeriodTime50ms 50
#define PeriodTime100ms 100
#define PeriodTime1000ms 1000

#define SDModeEnable 1
#define SDModeDisable 0

#define SDMode0 0x0
#define SDMode1 0x1
#define SDMode2 0x2
#define SDMode3 0x3

#define PLLDiv1 0x0<<2 // 48MHz
#define PLLDiv2 0x1<<2 // 24MHz
#define PLLDiv4 0x2<<2 // 12MHz
#define PLLDiv8 0x3<<2 // 6MHz

#define SET(reg,bit) (reg |= (1<<bit))
#define CLR(reg,bit) (reg &= ~(1<<bit))
#define SetBit(reg,bit,val) val?(reg |= (1<<bit)):(reg &= ~(1<<bit))
#define GetBit(reg,bit) (reg & (1<<bit))
#define SetReg(reg,val) (reg = val)
#define Q15(n) (signed short)(n*32767.0)
#define GET_HI_BYTE(v) *((unsigned char *)&v)
#define GET_LO_BYTE(v) *(((unsigned char *)&v)+1)
#define GET_BYTE(v,w) *(((unsigned char *)&v)+w)

typedef struct _MOTOR_COMPONENT// the struct name is a suggestion
{
	unsigned short a;
	unsigned short b;
	unsigned short c;
}MOTOR_COMPONENT,*PMOTOR_COMPONENT;// here are two types
extern xdata	int SW_HOT_Cnt;
extern unsigned char IPDFlag;
extern 	bit 	Start_Power_On;
extern	bit ZeroFlag;
extern	unsigned char PwmFlag;
extern	unsigned char TimerFlag;
extern	unsigned char TimerCount;
#endif
